#include <IpxBoxes/rtp-boxes.h>
#include <IpxCpuCodec/ctx_options.h>
#include <IpxCpuCodec/image_geometry.h>
#include <IpxCpuCodec/image_format_cfg.h>
#include <IpxCpuCodec/encode.h>
#include <IpxCpuCodec/decode.h>

size_t InitJpegXsBoxes(jxs_video_information_box_t* jxs_video_information_box, jxs_profile_and_level_box_t* jxs_profile_and_level_box, colour_specification_box_t* colour_specification_box);

bool ReadLicenseFile(const char* lic_fname, char* key);

bool InitImageGeometry(ipxcpucodec_image_geometry_t** image_geometry);

bool InitImageFormat(ipxcpucodec_image_format_cfg_t** image_format_cfg);

bool InitJpegXsEncoder(uint32_t CompressedVideoSize, ipxcpucodec_encoder_t** encoder,
                       ipxcpucodec_image_geometry_t** image_geometry, ipxcpucodec_image_format_cfg_t** image_format_cfg,
                       ipxcpucodec_ctx_options_t** ctx_options, ipxcpucodec_encode_options_t** encode_options);

bool InitJpegXsDecoder(ipxcpucodec_decoder_t** decoder, ipxcpucodec_image_geometry_t** image_geometry,
                       ipxcpucodec_image_format_cfg_t** image_format_cfg, ipxcpucodec_ctx_options_t** ctx_options,
                       ipxcpucodec_decode_options_t** decode_options);
