#include "tools_jpeg_xs.h"

size_t InitJpegXsBoxes(jxs_video_information_box_t* jxs_video_information_box,
   jxs_profile_and_level_box_t* jxs_profile_and_level_box, colour_specification_box_t* colour_specification_box)
{
   // Dummy values for jxs_video_information_box
   jxs_video_information_box->brat = 200;
   jxs_video_information_box->frat.interlace_mode = 0;
   jxs_video_information_box->frat.frame_reserved = 0;
   jxs_video_information_box->frat.frame_denominator = 1;
   jxs_video_information_box->frat.frame_numerator = 60;
   jxs_video_information_box->schar.valid_flag = 1;
   jxs_video_information_box->schar.sample_reserved = 0;
   jxs_video_information_box->schar.sample_bitdepth = 9;
   jxs_video_information_box->schar.sample_structure = 0;
   jxs_video_information_box->tcod.hours = 11;
   jxs_video_information_box->tcod.minutes = 14;
   jxs_video_information_box->tcod.seconds = 18;
   jxs_video_information_box->tcod.frame_count = 0;

   // Dummy values for jxs_profile_and_level_box
   jxs_profile_and_level_box->ppih = 11;
   jxs_profile_and_level_box->plev = 2;

   // Dummy values for colour_specification_box
   colour_specification_box->meth = 5;
   colour_specification_box->prec = 0;
   colour_specification_box->approx = 0;
   colour_specification_box->methdat.colour_primaries = 1;
   colour_specification_box->methdat.transfer_characteristics = 13;
   colour_specification_box->methdat.matrix_coefficients = 0;
   colour_specification_box->methdat.video_full_range_flag = 0;
   colour_specification_box->methdat.cicp_reserved = 0;

   return write_rtp_boxes(jxs_video_information_box, jxs_profile_and_level_box, colour_specification_box, nullptr);
}

bool ReadLicenseFile(const char* lic_fname, char* key)
{
   char ch;
   int i = 0;
   FILE* f = fopen(lic_fname, "rb");
   if (f == NULL) {
      fprintf(stderr, "[!] License file could not be read\n");
      return false;
   }

   /* skip the first line */
   key[0] = 0;
   ch = 'a';
   while ((ch != '\n') && (ch != EOF))
      ch = getc(f);
   ch = 'a';
   /* Read the second line */
   while ((ch != '\n') && (ch != EOF))
      key[i++] = ch = getc(f);
   key[i - 1] = 0;
   fclose(f);
   return true;
}

bool InitImageGeometry(ipxcpucodec_image_geometry_t** image_geometry)
{
   bool Return = true;
   int rv;

   if (Return == true)
   {
      // Init image geometry
      *image_geometry = ipxcpucodec_init_image_geometry();
      if ((*image_geometry) == NULL) 
      {
         fprintf(stderr, "[!] Could not initialize the image geometry.\n");
         Return = false;
      }
   }

   if (Return == true)
   {
      rv |= ipxcpucodec_set_image_dimensions(*image_geometry, 1920, 1080);
      rv |= ipxcpucodec_set_image_depth(*image_geometry, 10);
      rv |= ipxcpucodec_set_image_num_components(*image_geometry, 3);
      if (rv) {
         fprintf(stderr, "[!] Error while setting image geometry values.\n");
         Return = false;
      }
   }

   return Return;
}

bool InitImageFormat(ipxcpucodec_image_format_cfg_t** image_format_cfg)
{
   bool Return = true;
   int rv;
   if (Return == true)
   {
      // Init image format configuration
      *image_format_cfg = ipxcpucodec_init_image_format_cfg();
      if (!(*image_format_cfg)) {
         fprintf(stderr, "[!] Could not initialize the image format configuration.\n");
         Return = false;
      }
   }

   if (Return == true)
   {
      rv = ipxcpucodec_set_format(*image_format_cfg, IPXCPUCODEC_FORMAT_S210);
      if (rv) {
         fprintf(stderr, "[!] Error while setting format options.\n");
         Return = false;
      }
   }

   return Return;
}

bool InitJpegXsEncoder(uint32_t CompressedVideoSize, ipxcpucodec_encoder_t** encoder,
                       ipxcpucodec_image_geometry_t** image_geometry, ipxcpucodec_image_format_cfg_t** image_format_cfg, ipxcpucodec_ctx_options_t** ctx_options, ipxcpucodec_encode_options_t** encode_options)
{
   bool Return = true;

   int rv;

   unsigned char license_key[1024] = "";
   Return = ReadLicenseFile("license.dat", (char*)license_key);

   if (Return == true)
   {
      // Init the context options
      *ctx_options = ipxcpucodec_init_ctx_options();
      if (!(*ctx_options)) 
      {
         fprintf(stderr, "[!] Could not initialize the context options.\n");
         Return = false;
      }
   }

   if (Return == true)
   {
      rv = ipxcpucodec_set_license(*ctx_options, license_key);
      rv |= ipxcpucodec_set_max_dimensions(*ctx_options, 1920, 1080);
      rv |= ipxcpucodec_set_thread_count(*ctx_options, 2);
      if (rv) {
         fprintf(stderr, "[!] Error while setting context options.\n");
         Return = false;
      }
   }

   if(Return == true)
   {
      // Init the encoder
      *encoder = ipxcpucodec_init_encoder(*ctx_options);
      if (!(*encoder)) 
      {
         fprintf(stderr, "[!] Could not initialize the encoder.\n");
         Return = false;
      }
   }

   if (Return == true)
      Return = InitImageGeometry(image_geometry);

   if (Return == true)
      Return = InitImageFormat(image_format_cfg);

   if (Return == true)
   {
      // Init encoding options
      *encode_options = ipxcpucodec_init_encode_options();
      if (!(*encode_options))
      {
         fprintf(stderr, "[!] Could not initialize the encoding options.\n");
         Return = false;
      }
   }

   if (Return == true)
   {
      rv |= ipxcpucodec_enc_set_profile(*encode_options, IPXCPUCODEC_PROFILE_TICOXS_HIGH);
      rv |= ipxcpucodec_enc_set_codestream_size(*encode_options, CompressedVideoSize);
      rv |= ipxcpucodec_enc_set_ra_opt(*encode_options, IPXCPUCODEC_RA_OPT_VISUAL);
      rv |= ipxcpucodec_enc_set_encoder_mode(*encode_options, IPXCPUCODEC_ENC_MODE_QUALITY);
      if (rv) {
         fprintf(stderr, "[!] Error while setting encoding options.\n");
         Return = false;
      }
   }


   return Return;
}

bool InitJpegXsDecoder(ipxcpucodec_decoder_t** decoder, ipxcpucodec_image_geometry_t** image_geometry,
   ipxcpucodec_image_format_cfg_t** image_format_cfg, ipxcpucodec_ctx_options_t** ctx_options,
   ipxcpucodec_decode_options_t** decode_options)
{
   bool Return = true;

   int rv;

   unsigned char license_key[1024] = "";
   Return = ReadLicenseFile("license.dat", (char*)license_key);

   if (Return == true)
   {
      // Init the context options
      *ctx_options = ipxcpucodec_init_ctx_options();
      if (!(*ctx_options))
      {
         fprintf(stderr, "[!] Could not initialize the context options.\n");
         Return = false;
      }
   }

   if (Return == true)
   {
      rv = ipxcpucodec_set_license(*ctx_options, license_key);
      rv |= ipxcpucodec_set_max_dimensions(*ctx_options, 1920, 1080);
      rv |= ipxcpucodec_set_thread_count(*ctx_options, 2);
      if (rv) {
         fprintf(stderr, "[!] Error while setting context options.\n");
         Return = false;
      }
   }

   if (Return == true)
   {
      // Init the encoder
      *decoder = ipxcpucodec_init_decoder(*ctx_options);
      if (!(*decoder))
      {
         fprintf(stderr, "[!] Could not initialize the encoder.\n");
         Return = false;
      }
   }

   if (Return == true)
      Return = InitImageGeometry(image_geometry);

   if (Return == true)
      Return = InitImageFormat(image_format_cfg);

   if (Return == true)
   {
      // Init encoding options
      *decode_options = ipxcpucodec_init_decode_options();
      if (!(*decode_options))
      {
         fprintf(stderr, "[!] Could not initialize the encoding options.\n");
         Return = false;
      }
   }

   if (Return == true)
   {
      rv |= ipxcpucodec_dec_set_proxy(*decode_options, 0, 0);
      if (rv) {
         fprintf(stderr, "[!] Error while setting decoding options.\n");
         return EXIT_FAILURE;
      }
   }


   return Return;
}
