/*
   IP Virtual Card
   ------------
   PTP SAMPLE APPLICATION
   (c) DELTACAST
   --------------------------------------------------------

   This application demonstrates how to refresh the licensing information.

   In order to compile this application, path to VideoMasterIP_Core.h inclusion file
   and to VMIP library file must be properly configured.
*/

#include <iostream>
#include <string>
#include <thread>
#include <chrono>

#ifdef __GNUC__
#include <stdint-gcc.h>
#else
#include <stdint.h>
#endif

#if defined (__linux__) || defined (__APPLE__)
#include "../keyboard.h"
#else
#include <conio.h>
#define init_keyboard()
#define close_keyboard()
#endif

#include "../tools.h"

#include <videomasterip/videomasterip_core.h>

using namespace std::chrono_literals;

int main(int argc, char* argv[])
{
   VMIP_ERRORCODE Result = VMIPERR_NOERROR;

   init_keyboard();

   std::cout << "IP VIRTUAL CARD PTP SAMPLE APPLICATION\n(c) DELTACAST\n--------------------------------------------------------" << std::endl << std::endl;

   //Creates the context in which the stream will be created. This handle will be needed for all following calls.
   Result = VMIP_RefreshLicensing("");
   if(Result == VMIPERR_NOERROR)
      std::cout << "Licensing information successfully refreshed." << std::endl;
   else
      PrintWithLastError("Error when refreshing the licensing information.");

   close_keyboard();

   return 0;
}