# DELTACAST videomasterip sample

## How to build
The majority of samples have no dependency except the SDK.

The only samples that have dependencies are: 
- sample_st2110_20_rx_viewer.
    - This sample requires the following dependency:
        - glfw v3.3.6 (inherited from the library video-viewer)
- sample_st2110_22_[rx/tx]
    - This sample requires the following dependencies:
        - IntoPix's IpxBoxes
        - IntoPix's IpxCpuCodec

### Retrieve glfw dependency with Conan (optional)

The dependency to glfw is inherited from the library video-viewer (https://github.com/deltacasttv/video-viewer)

To use Conan 1.x to retrieve the dependency, create the `modules`` directory and use the following install command:

```shell
mkdir /path/to/modules
cd /path/to/modules
conan install glfw/3.3.6@ -b missing -g cmake_find_package
```

### Get IntoPix's IpxBoxes and IpxCpuCodec (optional)

Get in touch with IntoPix to get those dependencies.

### Building with CMake

If you used Conan to retrieve your dependencies, you can use the following commands to build the project:

### Compile samples:

```shell
cmake -S . -B build
cmake --build build
```

### Compile samples with video-viewer dependency:

```shell
cmake -S . -B build -DCMAKE_MODULE_PATH:STRING=/path/to/modules
cmake --build build
```