/*!
   @file
   @brief This file gathers ST2110-40 essence related public definitions as enumerations, structures and functions

   Copyright (c) DELTACAST. All rights reserved.

   THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
   KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR
   PURPOSE.
*/



#ifndef _VIDEOMASTERIP_ST2110_40_H_
#define _VIDEOMASTERIP_ST2110_40_H_

#include "videomasterip_core.h"
#include "videomasterip_anc.h"

#define ESSENCE_ST2110_40_ENUMBASE 0x03000000 /*!< Enumeration base value for ST2110-20 related enumerations */

/*!
   @brief VideoMaster supported ST2110-40 buffer type.

   The VMIP_ST2110_40_BUFFERTYPE enumeration lists all the supported ST2110-40 buffer type.

   @see VMIP_GetSlotBuffer
*/
typedef enum _VMIP_ST2110_40_BUFFERTYPE
{
   VMIP_ST2110_40_BT_ANC_Y_1 = ESSENCE_ST2110_40_ENUMBASE, /*!< Buffer type for luma ancillary data on data stream 1.*/
   VMIP_ST2110_40_BT_ANC_C_1                             , /*!< Buffer type for chroma ancillary data on data stream 1.*/
   VMIP_ST2110_40_BT_ANC_Y_2                             , /*!< Buffer type for luma ancillary data on data stream 2.*/
   VMIP_ST2110_40_BT_ANC_C_2                             , /*!< Buffer type for chroma ancillary data on data stream 2.*/
   VMIP_ST2110_40_BT_ANC_Y_3                             , /*!< Buffer type for luma ancillary data on data stream 3.*/
   VMIP_ST2110_40_BT_ANC_C_3                             , /*!< Buffer type for chroma ancillary data on data stream 3.*/
   VMIP_ST2110_40_BT_ANC_Y_4                             , /*!< Buffer type for luma ancillary data on data stream 4.*/
   VMIP_ST2110_40_BT_ANC_C_4                             , /*!< Buffer type for chroma ancillary data on data stream 4.*/
   VMIP_ST2110_40_BT_ANC_Y_5                             , /*!< Buffer type for luma ancillary data on data stream 5.*/
   VMIP_ST2110_40_BT_ANC_C_5                             , /*!< Buffer type for chroma ancillary data on data stream 5.*/
   VMIP_ST2110_40_BT_ANC_Y_6                             , /*!< Buffer type for luma ancillary data on data stream 6.*/
   VMIP_ST2110_40_BT_ANC_C_6                             , /*!< Buffer type for chroma ancillary data on data stream 6.*/
   VMIP_ST2110_40_BT_ANC_Y_7                             , /*!< Buffer type for luma ancillary data on data stream 7.*/
   VMIP_ST2110_40_BT_ANC_C_7                             , /*!< Buffer type for chroma ancillary data on data stream 7.*/
   VMIP_ST2110_40_BT_ANC_Y_8                             , /*!< Buffer type for luma ancillary data on data stream 8.*/
   VMIP_ST2110_40_BT_ANC_C_8                             , /*!< Buffer type for chroma ancillary data on data stream 8.*/
   NB_VMIP_ST2110_40_BUFFERTYPE
} VMIP_ST2110_40_BUFFERTYPE;

/*!
   @brief VideoMasterIP streams properties linked to a ST2110-40 essence.

  The VMIP_STREAM_ESSENCE_CONFIG_ST2110_40 structure contains all the available parameters for ST2110-40 stream configuration.

   @see VMIP_GetStreamEssenceConfig and VMIP_SetStreamEssenceConfig
*/
typedef struct _VMIP_STREAM_ESSENCE_CONFIG_ST2110_40
{
   VMIP_ANC_SDI_VIDEOSTANDARD SdiVideoStandard;      /*!< SDI video standard linked to the ANC stream */
}VMIP_STREAM_ESSENCE_CONFIG_ST2110_40;

#endif //_VIDEOMASTERIP_ST2110_40_H_