/*!
   @file
   @brief This file gathers ST2110-30 essence related public definitions as enumerations, structures and functions

   Copyright (c) DELTACAST. All rights reserved.

   THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
   KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR
   PURPOSE.
*/


#ifndef _VIDEOMASTERIP_ST2110_30_H_
#define _VIDEOMASTERIP_ST2110_30_H_

#include "videomasterip_audio.h"

#define ESSENCE_ST2110_30_ENUMBASE 0x02000000  /*!< Enumeration base value for ST2110-20 related enumerations */

/*!
   @brief VideoMaster supported ST2110-30 packet time

   The VMIP_AUDIO_SAMPLING_RATE enumeration lists all the supported audio packet time for ST2110-30 IP streams.

   @see VMIP_STREAM_ESSENCE_CONFIG_ST2110_30
*/
typedef enum _VMIP_ST2110_30_PACKET_TIME
{
   VMIP_ST2110_30_PACKET_TIME_1MS,       /*!< 1ms packet time */
   VMIP_ST2110_30_PACKET_TIME_125US,     /*!< 125us packet time */
   NB_VMIP_ST2110_30_PACKET_TIME
} VMIP_ST2110_30_PACKET_TIME;

/*!
   @brief VideoMaster supported ST2110-30 buffer type

   The VMIP_AUDIO_SAMPLING_RATE enumeration lists all the supported buffer type for ST2110-30 IP streams.

   @see VMIP_GetSlotBuffer
*/
typedef enum _VMIP_ST2110_30_BUFFERTYPE
{
   VMIP_ST2110_30_BT_AUDIO = ESSENCE_ST2110_30_ENUMBASE, /*! Audio buffer type.*/
   NB_VMIP_ST2110_30_BUFFERTYPE
} VMIP_ST2110_30_BUFFERTYPE;

   /*!
      @brief VideoMasterIP streams properties linked to a ST2110-30 essence.

      The VMIP_STREAM_ESSENCE_CONFIG_ST2110_30 structure contains all the available parameters for ST2110-30 stream configuration.

      @see VMIP_GetStreamEssenceConfig and VMIP_SetStreamEssenceConfig
   */
typedef struct _VMIP_STREAM_ESSENCE_CONFIG_ST2110_30
{
   VMIP_AUDIO_FORMAT Format;                /*!< Audio sample encoding.
                                                     Default is VMIP_AUDIO_FORMAT_L16. */
   VMIP_AUDIO_SAMPLING_RATE SamplingRate;   /*!< Audio sampling rate.
                                                     Default is VMIP_AUDIO_SAMPLING_RATE_48KHZ. */
   uint32_t NbChannel;                          /*!< Number of audio channels.
                                                     Default is 2. */
   VMIP_ST2110_30_PACKET_TIME PacketTime;       /*!< Packet Time.
                                                     Default is VMIP_ST2110_30_PACKET_TIME_1MS. */
   uint32_t PacketNbPerSlot;                    /*!< Number of packets that will be lock with eack LockSlot.
                                                     Default is 50. (only used if not in frame base mode)*/
   bool UseFrameBasedMode;                            /*!< Use frame based mode.
                                                       Default is false. */
   uint32_t Framerate;                          /*!< Frame rate (only used in frame based mode).*/

   bool HasUsClock;                             /*!< Use US clock. (only used in frame based mode)
                                                       Default is false. */

}VMIP_STREAM_ESSENCE_CONFIG_ST2110_30;


#endif //_VIDEOMASTERIP_ST2110_30_H_