/*!
   @file
   @brief This file gathers ST2110-22 essence related public definitions as enumerations, structures and functions

   Copyright (c) DELTACAST. All rights reserved.

   THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
   KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR
   PURPOSE.
*/

#ifndef _VIDEOMASTERIP_ST2110_22_H_
#define _VIDEOMASTERIP_ST2110_22_H_

#include "videomasterip_video.h"
 
#define ESSENCE_ST2110_22_ENUMBASE 0x04000000 /*!< Enumeration base value for ST2110-22 related enumerations */

/*!
   @brief VideoMaster supported ST2110-22 codec.

   The VMIP_ST2110_22_BUFFERTYPE enumeration lists all the supported ST2110-22 buffer type.

   @see VMIP_GetSlotBuffer
*/
typedef enum _VMIP_ST2110_22_CODEC
{
   VMIP_ST2110_22_CODEC_JPEG_XS, /*!< Codec JPEG XS.*/
   NB_VMIP_ST2110_22_CODEC
} VMIP_ST2110_22_CODEC;

/*!
   @brief VideoMaster supported ST2110-22 buffer type.

   The VMIP_ST2110_22_BUFFERTYPE enumeration lists all the supported ST2110-22 buffer type.

   @see VMIP_GetSlotBuffer
*/
typedef enum _VMIP_ST2110_22_BUFFERTYPE
{
   VMIP_ST2110_22_BT_FULL_FRAME = ESSENCE_ST2110_22_ENUMBASE, /*!< Buffer type for the full frame.*/
   VMIP_ST2110_22_BT_FIRST_FIELD,                             /*!< Buffer type for the first field. Only used for interlaced formats.*/
   VMIP_ST2110_22_BT_SECOND_FIELD,                            /*!< Buffer type for the second field. Only used for interlaced formats.*/
   NB_VMIP_ST2110_22_BUFFERTYPE
} VMIP_ST2110_22_BUFFERTYPE;

/*!
   @brief VideoMasterIP streams properties linked to a ST2110-22 essence.

   The VMIP_STREAM_ESSENCE_CONFIG_ST2110_22 structure contains all the available parameters for ST2110-22 stream configuration.

   @see VMIP_GetStreamEssenceConfig and VMIP_SetStreamEssenceConfig
*/
typedef struct _VMIP_STREAM_ESSENCE_CONFIG_ST2110_22
{
   VMIP_ST2110_22_CODEC Codec;                /*!< Codec. Default is VMIP_ST2110_22_CODEC_JPEG_XS. */
   uint64_t FrameSize;                        /*!< Size of the frame in bytes.                                                   
                                                   In RX, this can be bigger than the size of the frame actually received.
                                                   In RX, the size can be set to 0 if the size of the frame is not known.*/
   VMIP_VIDEO_STANDARD VideoStandard;         /*!< Video standard. Default is VMIP_ST2110_22_VIDEOSTD_1920X1080P30. */
   VMIP_VIDEO_COLORIMETRY Colorimetry;        /*!< Colorimetry. This field is only used when reading/writing SDP (see VMIP_ReadSDP and VMIP_WriteSDP)..*/
   VMIP_VIDEO_BIT_DEPTH BitDepth;             /*!< Bit depth. This field is only used when reading/writing SDP (see VMIP_ReadSDP and VMIP_WriteSDP)..*/
   VMIP_VIDEO_BIT_SAMPLING BitSampling;       /*!< Bit sampling. This field is only used when reading/writing SDP (see VMIP_ReadSDP and VMIP_WriteSDP).. */
   VMIP_VIDEO_TCS Tcs;                        /*!< TCS. This field is only used when reading/writing SDP (see VMIP_ReadSDP and VMIP_WriteSDP). */
}VMIP_STREAM_ESSENCE_CONFIG_ST2110_22;

#endif //_VIDEOMASTERIP_ST2110_22_H_
