/*!
   @file
   @brief This file gathers ST2110-21 norm related public definitions as enumerations, structures and functions

   Copyright (c) DELTACAST. All rights reserved.

   THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
   KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR
   PURPOSE.
*/

#ifndef _VIDEOMASTERIP_ST2110_21_H_
#define _VIDEOMASTERIP_ST2110_21_H_

/*!
   @brief VideoMasterIP Traffic shaping profile enumeration

   @see VMIP_NETWORK_ITF_STATUS
   @see VMIP_SDP_ADDITIONAL_INFORMATION
*/

typedef enum _VMIP_ST2110_21_TRAFFIC_SHAPING_PROFILE
{
   VMIP_ST2110_21_TRAFFIC_SHAPING_PROFILE_NARROW,
   VMIP_ST2110_21_TRAFFIC_SHAPING_PROFILE_NARROW_LINEAR,
   VMIP_ST2110_21_TRAFFIC_SHAPING_PROFILE_WIDE,
   NB_VMIP_ST2110_21_TRAFFIC_SHAPING_PROFILE
}VMIP_ST2110_21_TRAFFIC_SHAPING_PROFILE;



#endif //_VIDEOMASTERIP_ST2110_21_H_