/*!
   @file
   @brief This file gathers audio related public definitions as enumerations, structures and functions

   Copyright (c) DELTACAST. All rights reserved.

   THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
   KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR
   PURPOSE.
*/

#ifndef _VIDEOMASTERIP_AUDIO_H_
#define _VIDEOMASTERIP_AUDIO_H_

#include "videomasterip_core.h"

/*!
   @brief VideoMaster supported ST2110-30 sample encoding formats

   The VMIP_AUDIO_FORMAT enumeration lists all the supported audio sample encoding formats for ST2110-30 IP streams.

   @see VMIP_STREAM_ESSENCE_CONFIG_ST2110_30
*/
typedef enum _VMIP_AUDIO_FORMAT
{
   VMIP_AUDIO_FORMAT_L16,     /*!< 16-bit sample */
   VMIP_AUDIO_FORMAT_L24,     /*!< 24-bit sample */
   NB_VMIP_AUDIO_FORMAT
} VMIP_AUDIO_FORMAT;

/*!
   @brief VideoMaster supported ST2110-30 sampling rate

   The VMIP_AUDIO_SAMPLING_RATE enumeration lists all the supported audio sampling rate for ST2110-30 IP streams.

   @see VMIP_STREAM_ESSENCE_CONFIG_ST2110_30
*/
typedef enum _VMIP_AUDIO_SAMPLING_RATE
{
   VMIP_AUDIO_SAMPLING_RATE_48KHZ,      /*!< 48kHz sampling rate */
   VMIP_AUDIO_SAMPLING_RATE_96KHZ,      /*!< 96kHz sampling rate */
   NB_VMIP_AUDIO_SAMPLING_RATE
} VMIP_AUDIO_SAMPLING_RATE;
#endif //_VIDEOMASTERIP_VIDEO_H_