#!/bin/bash

#Store initial location
declare initial_location=$(pwd)
# Error handling for the whole shell script
set -e
trap 'errorcode=$? ; [[ $errorcode -ne 0 ]] && rm -rf $initial_location/dpdk-stable && exit $?' EXIT

###############################################################################
#                     DPDK installation shell script                        #
###############################################################################

install_dpdk()
{
   libraries=("libmlx5" "libibverbs")
   basics_drivers=common/iavf,net/i40e,net/ixgbe,net/e1000,net/igb,net/ice,net/cxgbe,net/bnxt,net/virtio,mempool/ring
   mlnx_drivers=bus/auxiliary,common/mlx5,net/mlx5
   enabled_drivers=""
   all_libraries_found=true
   git clone http://dpdk.org/git/dpdk-stable
   cd dpdk-stable
   git checkout v24.11.1
   #apply patches futher use
   cd ../
   patch -p0 < version.patch
   cd dpdk-stable
   #install only necessary libs and drivers from dpdk

   for lib in "${libraries[@]}"; do
      if ! pkg-config --exists $lib; then
         all_libraries_found=false
      fi
   done

   if [ "$all_libraries_found" = true ]; then
      enabled_drivers=${basics_drivers},${mlnx_drivers}
      echo "Compiling DPDK with Nvidia/Mellanox drivers"
   else
      enabled_drivers=${basics_drivers}
      echo "Compiling DPDK without Nvidia/Mellanox drivers"
   fi

   meson -Dmax_lcores=512 -Denable_kmods=true -Dtests=false -Ddisable_libs="" -Denable_drivers=$enabled_drivers build
   cd build
   ninja
   ninja install
}


check_access_right()
{
   if [ $(id -u) -ne 0 ]; then 
      echo "Please run as root"
      exit 1 
   fi
}

check_access_right
install_dpdk
