/*! VideomasterHD_String.h
    Copyright (c) 2023, DELTACAST. All rights reserved.

    THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
    KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
    IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR
    PURPOSE.
*/

#ifndef _VIDEOMASTERHD_STRING_H_
#define _VIDEOMASTERHD_STRING_H_

#include "VideoMasterHD_Core.h"
#include "VideoMasterHD_PTP.h" 
#include "VideoMasterHD_EDID.h"
#include "VideoMasterHD_Anc.h"
#include "VideoMasterHD_Asi.h"
#include "VideoMasterHD_Benchmark.h"
#include "VideoMasterHD_Dv.h"
#include "VideoMasterHD_Ip_Board.h"
#include "VideoMasterHD_Ip_S2022_Board.h"
#include "VideoMasterHD_Ip_ST2110_20.h"   
#include "VideoMasterHD_Ip_ST2110_30.h"   
#include "VideoMasterHD_Ip_ST2110_Board.h" 
#include "VideoMasterHD_Sdi.h" 
#include "VideoMasterHD_Sdi_Hdr_Metadata.h" 
#include "VideoMasterHD_Keyer.h" 
#include "VideoMasterHD_Sdi_Timecode.h" 
#include "VideoMasterHD_SDP.h" 
#include "VideoMasterHD_Dv.h" 

#ifndef EXCLUDE_API_FUNCTIONS

#ifdef __cplusplus
extern "C" {
#endif

/* -------------------- */
/* VideomasterHD_Core.h */
/* -------------------- */
   VIDEOMASTER_HD_API const char* VHD_CHANNEL_MODE_ToString(VHD_CHANNEL_MODE value);
   VIDEOMASTER_HD_API const char* VHD_CHANNEL_MODE_ToPrettyString(VHD_CHANNEL_MODE value);

   VIDEOMASTER_HD_API const char* VHD_BOARDTYPE_ToString(VHD_BOARDTYPE value);
   VIDEOMASTER_HD_API const char* VHD_BOARDTYPE_ToPrettyString(VHD_BOARDTYPE value);

   VIDEOMASTER_HD_API const char* VHD_CORE_BOARDPROPERTY_ToString(VHD_CORE_BOARDPROPERTY value);
   VIDEOMASTER_HD_API const char* VHD_CORE_BOARDPROPERTY_ToPrettyString(VHD_CORE_BOARDPROPERTY value);

   VIDEOMASTER_HD_API const char* VHD_CORE_STREAMPROPERTY_ToString(VHD_CORE_STREAMPROPERTY value);
   VIDEOMASTER_HD_API const char* VHD_CORE_STREAMPROPERTY_ToPrettyString(VHD_CORE_STREAMPROPERTY value);

   VIDEOMASTER_HD_API const char* VHD_STREAMTYPE_ToString(VHD_STREAMTYPE value);
   VIDEOMASTER_HD_API const char* VHD_STREAMTYPE_ToPrettyString(VHD_STREAMTYPE value);

   VIDEOMASTER_HD_API const char* VHD_CHANNELTYPE_ToString(VHD_CHANNELTYPE value);
   VIDEOMASTER_HD_API const char* VHD_CHANNELTYPE_ToPrettyString(VHD_CHANNELTYPE value);

   VIDEOMASTER_HD_API const char* VHD_BUSTYPE_ToString(VHD_BUSTYPE value);
   VIDEOMASTER_HD_API const char* VHD_BUSTYPE_ToPrettyString(VHD_BUSTYPE value);

   VIDEOMASTER_HD_API const char* VHD_TRANSFERSCHEME_ToString(VHD_TRANSFERSCHEME value);
   VIDEOMASTER_HD_API const char* VHD_TRANSFERSCHEME_ToPrettyString(VHD_TRANSFERSCHEME value);

   VIDEOMASTER_HD_API const char* VHD_BUFFERPACKING_ToString(VHD_BUFFERPACKING value);
   VIDEOMASTER_HD_API const char* VHD_BUFFERPACKING_ToPrettyString(VHD_BUFFERPACKING value);

   VIDEOMASTER_HD_API const char* VHD_OUTPUTMODE_ToString(VHD_OUTPUTMODE value);
   VIDEOMASTER_HD_API const char* VHD_OUTPUTMODE_ToPrettyString(VHD_OUTPUTMODE value);

   VIDEOMASTER_HD_API const char* VHD_ERRORCODE_ToString(VHD_ERRORCODE value);
   VIDEOMASTER_HD_API const char* VHD_ERRORCODE_ToPrettyString(VHD_ERRORCODE value);

   VIDEOMASTER_HD_API const char* VHD_BIDIRCFG_4C_ToString(VHD_BIDIRCFG_4C value);
   VIDEOMASTER_HD_API const char* VHD_BIDIRCFG_4C_ToPrettyString(VHD_BIDIRCFG_4C value);

   VIDEOMASTER_HD_API const char* VHD_BIDIRCFG_8C_ToString(VHD_BIDIRCFG_8C value);
   VIDEOMASTER_HD_API const char* VHD_BIDIRCFG_8C_ToPrettyString(VHD_BIDIRCFG_8C value);

   VIDEOMASTER_HD_API const char* VHD_COMPANION_CARD_TYPE_ToString(VHD_COMPANION_CARD_TYPE value);
   VIDEOMASTER_HD_API const char* VHD_COMPANION_CARD_TYPE_ToPrettyString(VHD_COMPANION_CARD_TYPE value);

   VIDEOMASTER_HD_API const char* VHD_COMPANION_CARD_CAPABILITY_ToString(VHD_COMPANION_CARD_CAPABILITY value);
   VIDEOMASTER_HD_API const char* VHD_COMPANION_CARD_CAPABILITY_ToPrettyString(VHD_COMPANION_CARD_CAPABILITY value);

   VIDEOMASTER_HD_API const char* VHD_TIMECODE_SOURCE_ToString(VHD_TIMECODE_SOURCE value);
   VIDEOMASTER_HD_API const char* VHD_TIMECODE_SOURCE_ToPrettyString(VHD_TIMECODE_SOURCE value);

   VIDEOMASTER_HD_API const char* VHD_HOSTID_TYPE_ToString(VHD_HOSTID_TYPE value);
   VIDEOMASTER_HD_API const char* VHD_HOSTID_TYPE_ToPrettyString(VHD_HOSTID_TYPE value);

   VIDEOMASTER_HD_API const char* VHD_CORE_BOARD_CAPABILITY_ToString(VHD_CORE_BOARD_CAPABILITY value);
   VIDEOMASTER_HD_API const char* VHD_CORE_BOARD_CAPABILITY_ToPrettyString(VHD_CORE_BOARD_CAPABILITY value);

   VIDEOMASTER_HD_API const char* VHD_LOWLATENCY_MODE_ToString(VHD_LOWLATENCY_MODE value);
   VIDEOMASTER_HD_API const char* VHD_LOWLATENCY_MODE_ToPrettyString(VHD_LOWLATENCY_MODE value);

   VIDEOMASTER_HD_API const char* VHD_SYSTEM_TIME_CLK_TYPE_ToString(VHD_SYSTEM_TIME_CLK_TYPE value);
   VIDEOMASTER_HD_API const char* VHD_SYSTEM_TIME_CLK_TYPE_ToPrettyString(VHD_SYSTEM_TIME_CLK_TYPE value);

   VIDEOMASTER_HD_API const char* VHD_WATCHDOG_TYPE_ToString(VHD_WATCHDOG_TYPE value);
   VIDEOMASTER_HD_API const char* VHD_WATCHDOG_TYPE_ToPrettyString(VHD_WATCHDOG_TYPE value);

   VIDEOMASTER_HD_API const char* VHD_FRAME_ACCURACY_TYPE_ToString(VHD_FRAME_ACCURACY_TYPE value);
   VIDEOMASTER_HD_API const char* VHD_FRAME_ACCURACY_TYPE_ToPrettyString(VHD_FRAME_ACCURACY_TYPE value);

   VIDEOMASTER_HD_API const char* VHD_FRAME_ACCURACY_PCSYNC_STATUS_ToString(VHD_FRAME_ACCURACY_PCSYNC_STATUS value);
   VIDEOMASTER_HD_API const char* VHD_FRAME_ACCURACY_PCSYNC_STATUS_ToPrettyString(VHD_FRAME_ACCURACY_PCSYNC_STATUS value);

   VIDEOMASTER_HD_API const char* VHD_TIMER_SOURCE_ToString(VHD_TIMER_SOURCE value);
   VIDEOMASTER_HD_API const char* VHD_TIMER_SOURCE_ToPrettyString(VHD_TIMER_SOURCE value);

   VIDEOMASTER_HD_API const char* VHD_CORE_GATEWAY_CAPABILITY_ToString(VHD_CORE_GATEWAY_CAPABILITY value);
   VIDEOMASTER_HD_API const char* VHD_CORE_GATEWAY_CAPABILITY_ToPrettyString(VHD_CORE_GATEWAY_CAPABILITY value);

   VIDEOMASTER_HD_API const char* VHD_CORE_GATEWAYPROPERTY_ToString(VHD_CORE_GATEWAYPROPERTY value);
   VIDEOMASTER_HD_API const char* VHD_CORE_GATEWAYPROPERTY_ToPrettyString(VHD_CORE_GATEWAYPROPERTY value);

   VIDEOMASTER_HD_API const char* VHD_BRD_FIRMWARE_TYPE_ToString(VHD_BRD_FIRMWARE_TYPE value);
   VIDEOMASTER_HD_API const char* VHD_BRD_FIRMWARE_TYPE_ToPrettyString(VHD_BRD_FIRMWARE_TYPE value);

   VIDEOMASTER_HD_API const char* VHD_CORE_BRD_CONFIG_SET_ToString(VHD_CORE_BRD_CONFIG_SET value);
   VIDEOMASTER_HD_API const char* VHD_CORE_BRD_CONFIG_SET_ToPrettyString(VHD_CORE_BRD_CONFIG_SET value);

   VIDEOMASTER_HD_API const char* VHD_CORE_BRD_CONFIG_IP_BOARDS_ToString(VHD_CORE_BRD_CONFIG_IP_BOARDS value);
   VIDEOMASTER_HD_API const char* VHD_CORE_BRD_CONFIG_IP_BOARDS_ToPrettyString(VHD_CORE_BRD_CONFIG_IP_BOARDS value);

   VIDEOMASTER_HD_API const char* VHD_CORE_BRD_CONFIG_3G_8C_BOARDS_ToString(VHD_CORE_BRD_CONFIG_3G_8C_BOARDS value);
   VIDEOMASTER_HD_API const char* VHD_CORE_BRD_CONFIG_3G_8C_BOARDS_ToPrettyString(VHD_CORE_BRD_CONFIG_3G_8C_BOARDS value);

   VIDEOMASTER_HD_API const char* VHD_CORE_BRD_CONFIG_12G_2C_BOARDS_ToString(VHD_CORE_BRD_CONFIG_12G_2C_BOARDS value);
   VIDEOMASTER_HD_API const char* VHD_CORE_BRD_CONFIG_12G_2C_BOARDS_ToPrettyString(VHD_CORE_BRD_CONFIG_12G_2C_BOARDS value);

   VIDEOMASTER_HD_API const char* VHD_CORE_BRD_CONFIG_12G_4C_BOARDS_ToString(VHD_CORE_BRD_CONFIG_12G_4C_BOARDS value);
   VIDEOMASTER_HD_API const char* VHD_CORE_BRD_CONFIG_12G_4C_BOARDS_ToPrettyString(VHD_CORE_BRD_CONFIG_12G_4C_BOARDS value);

   VIDEOMASTER_HD_API const char* VHD_CORE_BRD_CONFIG_ST2110_BOARDS_ToString(VHD_CORE_BRD_CONFIG_ST2110_BOARDS value);
   VIDEOMASTER_HD_API const char* VHD_CORE_BRD_CONFIG_ST2110_BOARDS_ToPrettyString(VHD_CORE_BRD_CONFIG_ST2110_BOARDS value);

   VIDEOMASTER_HD_API const char* VHD_CORE_BRD_CONFIG_FLEX_12G_BOARDS_ToString(VHD_CORE_BRD_CONFIG_FLEX_12G_BOARDS value);
   VIDEOMASTER_HD_API const char* VHD_CORE_BRD_CONFIG_FLEX_12G_BOARDS_ToPrettyString(VHD_CORE_BRD_CONFIG_FLEX_12G_BOARDS value);

   VIDEOMASTER_HD_API const char* VHD_CORE_BRD_CONFIG_12G_4X2C_BOARDS_ToString(VHD_CORE_BRD_CONFIG_12G_4X2C_BOARDS value);
   VIDEOMASTER_HD_API const char* VHD_CORE_BRD_CONFIG_12G_4X2C_BOARDS_ToPrettyString(VHD_CORE_BRD_CONFIG_12G_4X2C_BOARDS value);

   VIDEOMASTER_HD_API const char* VHD_GTW_FIRMWARE_TYPE_ToString(VHD_GTW_FIRMWARE_TYPE value);
   VIDEOMASTER_HD_API const char* VHD_GTW_FIRMWARE_TYPE_ToPrettyString(VHD_GTW_FIRMWARE_TYPE value);

   VIDEOMASTER_HD_API const char* VHD_THUMBNAIL_RATIO_ToString(VHD_THUMBNAIL_RATIO value);
   VIDEOMASTER_HD_API const char* VHD_THUMBNAIL_RATIO_ToPrettyString(VHD_THUMBNAIL_RATIO value);

   VIDEOMASTER_HD_API const char* VHD_MRRS_ToString(VHD_MRRS value);
   VIDEOMASTER_HD_API const char* VHD_MRRS_ToPrettyString(VHD_MRRS value);

   VIDEOMASTER_HD_API const char* VHD_FAN_SPEED_MODE_ToString(VHD_FAN_SPEED_MODE value);
   VIDEOMASTER_HD_API const char* VHD_FAN_SPEED_MODE_ToPrettyString(VHD_FAN_SPEED_MODE value);

   VIDEOMASTER_HD_API const char* VHD_CORE_CHANNELPROPERTY_ToString(VHD_CORE_CHANNELPROPERTY value);
   VIDEOMASTER_HD_API const char* VHD_CORE_CHANNELPROPERTY_ToPrettyString(VHD_CORE_CHANNELPROPERTY value);

   VIDEOMASTER_HD_API const char* VHD_TIMER_TICK_MODE_ToString(VHD_TIMER_TICK_MODE value);
   VIDEOMASTER_HD_API const char* VHD_TIMER_TICK_MODE_ToPrettyString(VHD_TIMER_TICK_MODE value);

   VIDEOMASTER_HD_API const char* VHD_CHANNEL_DIRECTION_ToString(VHD_CHANNEL_DIRECTION value);
   VIDEOMASTER_HD_API const char* VHD_CHANNEL_DIRECTION_ToPrettyString(VHD_CHANNEL_DIRECTION value);

/* -------------------- */
/* VideomasterHD_Anc.h  */
/* -------------------- */

   VIDEOMASTER_HD_API const char* VHD_SAMPLETYPE_ToString(VHD_SAMPLETYPE value);
   VIDEOMASTER_HD_API const char* VHD_SAMPLETYPE_ToPrettyString(VHD_SAMPLETYPE value);

/* -------------------- */
/* VideomasterHD_Asi.h  */
/* -------------------- */

   VIDEOMASTER_HD_API const char* VHD_ASI_BOARDPROPERTY_ToString(VHD_ASI_BOARDPROPERTY value);
   VIDEOMASTER_HD_API const char* VHD_ASI_BOARDPROPERTY_ToPrettyString(VHD_ASI_BOARDPROPERTY value);

   VIDEOMASTER_HD_API const char* VHD_ASI_STREAMPROPERTY_ToString(VHD_ASI_STREAMPROPERTY value);
   VIDEOMASTER_HD_API const char* VHD_ASI_STREAMPROPERTY_ToPrettyString(VHD_ASI_STREAMPROPERTY value);

   VIDEOMASTER_HD_API const char* VHD_ASI_STREAMPROCMODE_ToString(VHD_ASI_STREAMPROCMODE value);
   VIDEOMASTER_HD_API const char* VHD_ASI_STREAMPROCMODE_ToPrettyString(VHD_ASI_STREAMPROCMODE value);

   VIDEOMASTER_HD_API const char* VHD_ASI_BUFFERTYPE_ToString(VHD_ASI_BUFFERTYPE value);
   VIDEOMASTER_HD_API const char* VHD_ASI_BUFFERTYPE_ToPrettyString(VHD_ASI_BUFFERTYPE value);

   VIDEOMASTER_HD_API const char* VHD_ASI_BITRATESOURCE_ToString(VHD_ASI_BITRATESOURCE value);
   VIDEOMASTER_HD_API const char* VHD_ASI_BITRATESOURCE_ToPrettyString(VHD_ASI_BITRATESOURCE value);

   VIDEOMASTER_HD_API const char* VHD_ASI_CLOCKSOURCE_ToString(VHD_ASI_CLOCKSOURCE value);
   VIDEOMASTER_HD_API const char* VHD_ASI_CLOCKSOURCE_ToPrettyString(VHD_ASI_CLOCKSOURCE value);

   VIDEOMASTER_HD_API const char* VHD_ASI_TSPACKETTYPE_ToString(VHD_ASI_TSPACKETTYPE value);
   VIDEOMASTER_HD_API const char* VHD_ASI_TSPACKETTYPE_ToPrettyString(VHD_ASI_TSPACKETTYPE value);

   VIDEOMASTER_HD_API const char* VHD_ASI_BRINTPERIOD_ToString(VHD_ASI_BRINTPERIOD value);
   VIDEOMASTER_HD_API const char* VHD_ASI_BRINTPERIOD_ToPrettyString(VHD_ASI_BRINTPERIOD value);

   VIDEOMASTER_HD_API const char* VHD_ASI_BOARD_CAPABILITY_ToString(VHD_ASI_BOARD_CAPABILITY value);
   VIDEOMASTER_HD_API const char* VHD_ASI_BOARD_CAPABILITY_ToPrettyString(VHD_ASI_BOARD_CAPABILITY value);

   VIDEOMASTER_HD_API const char* VHD_ASI_POLARITY_ToString(VHD_ASI_POLARITY value);
   VIDEOMASTER_HD_API const char* VHD_ASI_POLARITY_ToPrettyString(VHD_ASI_POLARITY value);

   VIDEOMASTER_HD_API const char* VHD_GPIOMUX_ToString(VHD_GPIOMUX value);
   VIDEOMASTER_HD_API const char* VHD_GPIOMUX_ToPrettyString(VHD_GPIOMUX value);

/* -------------------------- */
/* VideomasterHD_Benchmark.h  */
/* -------------------------- */

   VIDEOMASTER_HD_API const char* VHD_PCIEBENCHMARK_DIRECTION_ToString(VHD_PCIEBENCHMARK_DIRECTION value);
   VIDEOMASTER_HD_API const char* VHD_PCIEBENCHMARK_DIRECTION_ToPrettyString(VHD_PCIEBENCHMARK_DIRECTION value);

   VIDEOMASTER_HD_API const char* VHD_DV_STREAMPROPERTY_ToString(VHD_DV_STREAMPROPERTY value);
   VIDEOMASTER_HD_API const char* VHD_DV_STREAMPROPERTY_ToPrettyString(VHD_DV_STREAMPROPERTY value);
    
   VIDEOMASTER_HD_API const char* VHD_DV_STREAMPROCMODE_ToString(VHD_DV_STREAMPROCMODE value);
   VIDEOMASTER_HD_API const char* VHD_DV_STREAMPROCMODE_ToPrettyString(VHD_DV_STREAMPROCMODE value);

   VIDEOMASTER_HD_API const char* VHD_DV_BUFFERTYPE_ToString(VHD_DV_BUFFERTYPE value);
   VIDEOMASTER_HD_API const char* VHD_DV_BUFFERTYPE_ToPrettyString(VHD_DV_BUFFERTYPE value);

   VIDEOMASTER_HD_API const char* VHD_DV_MODE_ToString(VHD_DV_MODE value);
   VIDEOMASTER_HD_API const char* VHD_DV_MODE_ToPrettyString(VHD_DV_MODE value);

   VIDEOMASTER_HD_API const char* VHD_DV_STANDARD_ToString(VHD_DV_STANDARD value);
   VIDEOMASTER_HD_API const char* VHD_DV_STANDARD_ToPrettyString(VHD_DV_STANDARD value);

   VIDEOMASTER_HD_API const char* VHD_DV_EEDID_PRESET_ToString(VHD_DV_EEDID_PRESET value);
   VIDEOMASTER_HD_API const char* VHD_DV_EEDID_PRESET_ToPrettyString(VHD_DV_EEDID_PRESET value);

   VIDEOMASTER_HD_API const char* VHD_DV_CS_ToString(VHD_DV_CS value);
   VIDEOMASTER_HD_API const char* VHD_DV_CS_ToPrettyString(VHD_DV_CS value);

   VIDEOMASTER_HD_API const char* VHD_DV_HDMI_VIDEOSTANDARD_ToString(VHD_DV_HDMI_VIDEOSTANDARD value);
   VIDEOMASTER_HD_API const char* VHD_DV_HDMI_VIDEOSTANDARD_ToPrettyString(VHD_DV_HDMI_VIDEOSTANDARD value);

   VIDEOMASTER_HD_API const char* VHD_DV_HDMI_3D_MODE_ToString(VHD_DV_HDMI_3D_MODE value);
   VIDEOMASTER_HD_API const char* VHD_DV_HDMI_3D_MODE_ToPrettyString(VHD_DV_HDMI_3D_MODE value);

   VIDEOMASTER_HD_API const char* VHD_DV_AUDIO_TYPE_ToString(VHD_DV_AUDIO_TYPE value);
   VIDEOMASTER_HD_API const char* VHD_DV_AUDIO_TYPE_ToPrettyString(VHD_DV_AUDIO_TYPE value);

   VIDEOMASTER_HD_API const char* VHD_DV_BOARD_CAPABILITY_ToString(VHD_DV_BOARD_CAPABILITY value);
   VIDEOMASTER_HD_API const char* VHD_DV_BOARD_CAPABILITY_ToPrettyString(VHD_DV_BOARD_CAPABILITY value);

   VIDEOMASTER_HD_API const char* VHD_DV_DPLINKRATE_ToString(VHD_DV_DPLINKRATE value);
   VIDEOMASTER_HD_API const char* VHD_DV_DPLINKRATE_ToPrettyString(VHD_DV_DPLINKRATE value);

   VIDEOMASTER_HD_API const char* VHD_DV_HPDSTATE_ToString(VHD_DV_HPDSTATE value);
   VIDEOMASTER_HD_API const char* VHD_DV_HPDSTATE_ToPrettyString(VHD_DV_HPDSTATE value);

   VIDEOMASTER_HD_API const char* VHD_DV_SAMPLING_ToString(VHD_DV_SAMPLING value);
   VIDEOMASTER_HD_API const char* VHD_DV_SAMPLING_ToPrettyString(VHD_DV_SAMPLING value);

   VIDEOMASTER_HD_API const char* VHD_DV_PHYSICAL_CODING_ToString(VHD_DV_PHYSICAL_CODING value);
   VIDEOMASTER_HD_API const char* VHD_DV_PHYSICAL_CODING_ToPrettyString(VHD_DV_PHYSICAL_CODING value);

/* ------------------- --*/
/* VideomasterHD_EDID.h  */
/* --------------------- */

   VIDEOMASTER_HD_API const char* VHD_EDID_WARNING_CODE_ToString(VHD_EDID_WARNING_CODE value);
   VIDEOMASTER_HD_API const char* VHD_EDID_WARNING_CODE_ToPrettyString(VHD_EDID_WARNING_CODE value);

   VIDEOMASTER_HD_API const char* VHD_EDID_EXTENSION_TYPE_ToString(VHD_EDID_EXTENSION_TYPE value);
   VIDEOMASTER_HD_API const char* VHD_EDID_EXTENSION_TYPE_ToPrettyString(VHD_EDID_EXTENSION_TYPE value);

   VIDEOMASTER_HD_API const char* VHD_EDID_ESTABLISHED_TIMING_ToString(VHD_EDID_ESTABLISHED_TIMING value);
   VIDEOMASTER_HD_API const char* VHD_EDID_ESTABLISHED_TIMING_ToPrettyString(VHD_EDID_ESTABLISHED_TIMING value);

   VIDEOMASTER_HD_API const char* VHD_EDID_BIT_DEPTH_ToString(VHD_EDID_BIT_DEPTH value);
   VIDEOMASTER_HD_API const char* VHD_EDID_BIT_DEPTH_ToPrettyString(VHD_EDID_BIT_DEPTH value);

   VIDEOMASTER_HD_API const char* VHD_EDID_VIDEO_INTERFACE_ToString(VHD_EDID_VIDEO_INTERFACE value);
   VIDEOMASTER_HD_API const char* VHD_EDID_VIDEO_INTERFACE_ToPrettyString(VHD_EDID_VIDEO_INTERFACE value);

   VIDEOMASTER_HD_API const char* VHD_EDID_DISPLAY_TYPE_DIGITAL_ToString(VHD_EDID_DISPLAY_TYPE_DIGITAL value);
   VIDEOMASTER_HD_API const char* VHD_EDID_DISPLAY_TYPE_DIGITAL_ToPrettyString(VHD_EDID_DISPLAY_TYPE_DIGITAL value);

   VIDEOMASTER_HD_API const char* VHD_EDID_DISPLAY_TYPE_ANALOG_ToString(VHD_EDID_DISPLAY_TYPE_ANALOG value);
   VIDEOMASTER_HD_API const char* VHD_EDID_DISPLAY_TYPE_ANALOG_ToPrettyString(VHD_EDID_DISPLAY_TYPE_ANALOG value);

   VIDEOMASTER_HD_API const char* VHD_EDID_ASPECT_RATIO_ToString(VHD_EDID_ASPECT_RATIO value);
   VIDEOMASTER_HD_API const char* VHD_EDID_ASPECT_RATIO_ToPrettyString(VHD_EDID_ASPECT_RATIO value);

   VIDEOMASTER_HD_API const char* VHD_EDID_STEREO_MODE_ToString(VHD_EDID_STEREO_MODE value);
   VIDEOMASTER_HD_API const char* VHD_EDID_STEREO_MODE_ToPrettyString(VHD_EDID_STEREO_MODE value);

   VIDEOMASTER_HD_API const char* VHD_EDID_SYNC_TYPE_ToString(VHD_EDID_SYNC_TYPE value);
   VIDEOMASTER_HD_API const char* VHD_EDID_SYNC_TYPE_ToPrettyString(VHD_EDID_SYNC_TYPE value);

   VIDEOMASTER_HD_API const char* VHD_EDID_DESCRIPTOR_TYPE_ToString(VHD_EDID_DESCRIPTOR_TYPE value);
   VIDEOMASTER_HD_API const char* VHD_EDID_DESCRIPTOR_TYPE_ToPrettyString(VHD_EDID_DESCRIPTOR_TYPE value);

   VIDEOMASTER_HD_API const char* VHD_EDID_EXTENDED_TIMING_INFORMATION_TYPE_ToString(VHD_EDID_EXTENDED_TIMING_INFORMATION_TYPE value);
   VIDEOMASTER_HD_API const char* VHD_EDID_EXTENDED_TIMING_INFORMATION_TYPE_ToPrettyString(VHD_EDID_EXTENDED_TIMING_INFORMATION_TYPE value);

   VIDEOMASTER_HD_API const char* VHD_EDID_ADDITIONAL_TIMING_ToString(VHD_EDID_ADDITIONAL_TIMING value);
   VIDEOMASTER_HD_API const char* VHD_EDID_ADDITIONAL_TIMING_ToPrettyString(VHD_EDID_ADDITIONAL_TIMING value);

   VIDEOMASTER_HD_API const char* VHD_EDID_CEA_861_BLOCK_TYPE_ToString(VHD_EDID_CEA_861_BLOCK_TYPE value);
   VIDEOMASTER_HD_API const char* VHD_EDID_CEA_861_BLOCK_TYPE_ToPrettyString(VHD_EDID_CEA_861_BLOCK_TYPE value);

   VIDEOMASTER_HD_API const char* VHD_EDID_CEA_861_AUDIO_FORMAT_ToString(VHD_EDID_CEA_861_AUDIO_FORMAT value);
   VIDEOMASTER_HD_API const char* VHD_EDID_CEA_861_AUDIO_FORMAT_ToPrettyString(VHD_EDID_CEA_861_AUDIO_FORMAT value);

   VIDEOMASTER_HD_API const char* VHD_EDID_UTF_TYPE_ToString(VHD_EDID_UTF_TYPE value);
   VIDEOMASTER_HD_API const char* VHD_EDID_UTF_TYPE_ToPrettyString(VHD_EDID_UTF_TYPE value);

/* ------------------------- */
/* VideoMasterHD_Ip_Board.h  */
/* ------------------------- */

   VIDEOMASTER_HD_API const char* VHD_IP_BRD_BOARDPROPERTY_ToString(VHD_IP_BRD_BOARDPROPERTY value);
   VIDEOMASTER_HD_API const char* VHD_IP_BRD_BOARDPROPERTY_ToPrettyString(VHD_IP_BRD_BOARDPROPERTY value);

   VIDEOMASTER_HD_API const char* VHD_IP_BRD_ETHERNETPORTPROPERTY_ToString(VHD_IP_BRD_ETHERNETPORTPROPERTY value);
   VIDEOMASTER_HD_API const char* VHD_IP_BRD_ETHERNETPORTPROPERTY_ToPrettyString(VHD_IP_BRD_ETHERNETPORTPROPERTY value);

   VIDEOMASTER_HD_API const char* VHD_IP_BRD_ETHERNETPORT_ToString(VHD_IP_BRD_ETHERNETPORT value);
   VIDEOMASTER_HD_API const char* VHD_IP_BRD_ETHERNETPORT_ToPrettyString(VHD_IP_BRD_ETHERNETPORT value);

   VIDEOMASTER_HD_API const char* VHD_IP_BRD_STREAMPROPERTY_ToString(VHD_IP_BRD_STREAMPROPERTY value);
   VIDEOMASTER_HD_API const char* VHD_IP_BRD_STREAMPROPERTY_ToPrettyString(VHD_IP_BRD_STREAMPROPERTY value);

   VIDEOMASTER_HD_API const char* VHD_IP_BOARD_CAPABILITY_ToString(VHD_IP_BOARD_CAPABILITY value);
   VIDEOMASTER_HD_API const char* VHD_IP_BOARD_CAPABILITY_ToPrettyString(VHD_IP_BOARD_CAPABILITY value);

   VIDEOMASTER_HD_API const char* VHD_IP_BRD_FILTERMODEMULTICAST_ToString(VHD_IP_BRD_FILTERMODEMULTICAST value);
   VIDEOMASTER_HD_API const char* VHD_IP_BRD_FILTERMODEMULTICAST_ToPrettyString(VHD_IP_BRD_FILTERMODEMULTICAST value);

   VIDEOMASTER_HD_API const char* VHD_IP_BRD_IGMP_VERSION_ToString(VHD_IP_BRD_IGMP_VERSION value);
   VIDEOMASTER_HD_API const char* VHD_IP_BRD_IGMP_VERSION_ToPrettyString(VHD_IP_BRD_IGMP_VERSION value);

   VIDEOMASTER_HD_API const char* VHD_IP_BRD_LLDP_MAC_ADDRESS_MODE_ToString(VHD_IP_BRD_LLDP_MAC_ADDRESS_MODE value);
   VIDEOMASTER_HD_API const char* VHD_IP_BRD_LLDP_MAC_ADDRESS_MODE_ToPrettyString(VHD_IP_BRD_LLDP_MAC_ADDRESS_MODE value);

   VIDEOMASTER_HD_API const char* VHD_IP_BRD_LLDP_TLV_OPTIONAL_NAMES_ToString(VHD_IP_BRD_LLDP_TLV_OPTIONAL_NAMES value);
   VIDEOMASTER_HD_API const char* VHD_IP_BRD_LLDP_TLV_OPTIONAL_NAMES_ToPrettyString(VHD_IP_BRD_LLDP_TLV_OPTIONAL_NAMES value);

   VIDEOMASTER_HD_API const char* VHD_IP_BRD_LLDP_TLV_CHASSIS_ID_SUBTYPE_ToString(VHD_IP_BRD_LLDP_TLV_CHASSIS_ID_SUBTYPE value);
   VIDEOMASTER_HD_API const char* VHD_IP_BRD_LLDP_TLV_CHASSIS_ID_SUBTYPE_ToPrettyString(VHD_IP_BRD_LLDP_TLV_CHASSIS_ID_SUBTYPE value);

   VIDEOMASTER_HD_API const char* VHD_IP_BRD_LLDP_TLV_PORT_ID_SUBTYPE_ToString(VHD_IP_BRD_LLDP_TLV_PORT_ID_SUBTYPE value);
   VIDEOMASTER_HD_API const char* VHD_IP_BRD_LLDP_TLV_PORT_ID_SUBTYPE_ToPrettyString(VHD_IP_BRD_LLDP_TLV_PORT_ID_SUBTYPE value);

/* ------------------------------- */
/* VideomasterHD_Ip_S2022_Board.h  */
/* ------------------------------- */

   VIDEOMASTER_HD_API const char* VHD_S2022_BRD_STREAMPROPERTY_ToString(VHD_S2022_BRD_STREAMPROPERTY value);
   VIDEOMASTER_HD_API const char* VHD_S2022_BRD_STREAMPROPERTY_ToPrettyString(VHD_S2022_BRD_STREAMPROPERTY value);

/* ------------------------------- */
/* VideomasterHD_Ip_ST2110_20.h    */
/* ------------------------------- */

   VIDEOMASTER_HD_API const char* VHD_ST2110_20_STREAMPROPERTY_ToString(VHD_ST2110_20_STREAMPROPERTY value);
   VIDEOMASTER_HD_API const char* VHD_ST2110_20_STREAMPROPERTY_ToPrettyString(VHD_ST2110_20_STREAMPROPERTY value);

   VIDEOMASTER_HD_API const char* VHD_ST2110_20_VIDEO_STANDARD_ToString(VHD_ST2110_20_VIDEO_STANDARD value);
   VIDEOMASTER_HD_API const char* VHD_ST2110_20_VIDEO_STANDARD_ToPrettyString(VHD_ST2110_20_VIDEO_STANDARD value);

   VIDEOMASTER_HD_API const char* VHD_ST2110_20_SAMPLING_ToString(VHD_ST2110_20_SAMPLING value);
   VIDEOMASTER_HD_API const char* VHD_ST2110_20_SAMPLING_ToPrettyString(VHD_ST2110_20_SAMPLING value);

   VIDEOMASTER_HD_API const char* VHD_ST2110_20_DEPTH_ToString(VHD_ST2110_20_DEPTH value);
   VIDEOMASTER_HD_API const char* VHD_ST2110_20_DEPTH_ToPrettyString(VHD_ST2110_20_DEPTH value);

   VIDEOMASTER_HD_API const char* VHD_ST2110_20_TRAFFIC_SHAPING_MODE_ToString(VHD_ST2110_20_TRAFFIC_SHAPING_MODE value);
   VIDEOMASTER_HD_API const char* VHD_ST2110_20_TRAFFIC_SHAPING_MODE_ToPrettyString(VHD_ST2110_20_TRAFFIC_SHAPING_MODE value);

/* ------------------------------- */
/* VideomasterHD_Ip_ST2110_30.h    */
/* ------------------------------- */

   VIDEOMASTER_HD_API const char* VHD_ST2110_30_STREAMPROPERTY_ToString(VHD_ST2110_30_STREAMPROPERTY value);
   VIDEOMASTER_HD_API const char* VHD_ST2110_30_STREAMPROPERTY_ToPrettyString(VHD_ST2110_30_STREAMPROPERTY value);

   VIDEOMASTER_HD_API const char* VHD_ST2110_30_FORMAT_ToString(VHD_ST2110_30_FORMAT value);
   VIDEOMASTER_HD_API const char* VHD_ST2110_30_FORMAT_ToPrettyString(VHD_ST2110_30_FORMAT value);

   VIDEOMASTER_HD_API const char* VHD_ST2110_30_SAMPLING_RATE_ToString(VHD_ST2110_30_SAMPLING_RATE value);
   VIDEOMASTER_HD_API const char* VHD_ST2110_30_SAMPLING_RATE_ToPrettyString(VHD_ST2110_30_SAMPLING_RATE value);

   VIDEOMASTER_HD_API const char* VHD_ST2110_30_PACKET_TIME_ToString(VHD_ST2110_30_PACKET_TIME value);
   VIDEOMASTER_HD_API const char* VHD_ST2110_30_PACKET_TIME_ToPrettyString(VHD_ST2110_30_PACKET_TIME value);

   VIDEOMASTER_HD_API const char* VHD_ST2110_30_CHANNEL_TYPE_ToString(VHD_ST2110_30_CHANNEL_TYPE value);
   VIDEOMASTER_HD_API const char* VHD_ST2110_30_CHANNEL_TYPE_ToPrettyString(VHD_ST2110_30_CHANNEL_TYPE value);

/* ------------------------------- */
/* VideomasterHD_Ip_ST2110_Board.h */
/* ------------------------------- */

   VIDEOMASTER_HD_API const char* VHD_ST2110_STREAMPROCMODE_ToString(VHD_ST2110_STREAMPROCMODE value);
   VIDEOMASTER_HD_API const char* VHD_ST2110_STREAMPROCMODE_ToPrettyString(VHD_ST2110_STREAMPROCMODE value);

   VIDEOMASTER_HD_API const char* VHD_ST2110_BUFFERTYPE_ToString(VHD_ST2110_BUFFERTYPE value);
   VIDEOMASTER_HD_API const char* VHD_ST2110_BUFFERTYPE_ToPrettyString(VHD_ST2110_BUFFERTYPE value);

/* ------------------------------- */
/* VideomasterHD_PTP.h */
/* ------------------------------- */

   VIDEOMASTER_HD_API const char* VHD_PTP_PORT_STATE_ToString(VHD_PTP_PORT_STATE value);
   VIDEOMASTER_HD_API const char* VHD_PTP_PORT_STATE_ToPrettyString(VHD_PTP_PORT_STATE value);

   VIDEOMASTER_HD_API const char* VHD_PTP_PROFILE_ToString(VHD_PTP_PROFILE value);
   VIDEOMASTER_HD_API const char* VHD_PTP_PROFILE_ToPrettyString(VHD_PTP_PROFILE value);

   VIDEOMASTER_HD_API const char* VHD_PTP_DELAYMECHANISM_ToString(VHD_PTP_DELAYMECHANISM value);
   VIDEOMASTER_HD_API const char* VHD_PTP_DELAYMECHANISM_ToPrettyString(VHD_PTP_DELAYMECHANISM value);

/* ------------------------------- */
/* VideomasterHD_Sdi.h */
/* ------------------------------- */

   VIDEOMASTER_HD_API const char* VHD_SDI_BOARDPROPERTY_ToString(VHD_SDI_BOARDPROPERTY value);
   VIDEOMASTER_HD_API const char* VHD_SDI_BOARDPROPERTY_ToPrettyString(VHD_SDI_BOARDPROPERTY value);

   VIDEOMASTER_HD_API const char* VHD_SDI_STREAMPROPERTY_ToString(VHD_SDI_STREAMPROPERTY value);
   VIDEOMASTER_HD_API const char* VHD_SDI_STREAMPROPERTY_ToPrettyString(VHD_SDI_STREAMPROPERTY value);

   VIDEOMASTER_HD_API const char* VHD_CLOCKDIVISOR_ToString(VHD_CLOCKDIVISOR value);
   VIDEOMASTER_HD_API const char* VHD_CLOCKDIVISOR_ToPrettyString(VHD_CLOCKDIVISOR value);

   VIDEOMASTER_HD_API const char* VHD_GENLOCKSOURCE_ToString(VHD_GENLOCKSOURCE value);
   VIDEOMASTER_HD_API const char* VHD_GENLOCKSOURCE_ToPrettyString(VHD_GENLOCKSOURCE value);

   VIDEOMASTER_HD_API const char* VHD_VIDEOSTANDARD_ToString(VHD_VIDEOSTANDARD value);
   VIDEOMASTER_HD_API const char* VHD_VIDEOSTANDARD_ToPrettyString(VHD_VIDEOSTANDARD value);

   VIDEOMASTER_HD_API const char* VHD_SDI_STREAMPROCMODE_ToString(VHD_SDI_STREAMPROCMODE value);
   VIDEOMASTER_HD_API const char* VHD_SDI_STREAMPROCMODE_ToPrettyString(VHD_SDI_STREAMPROCMODE value);

   VIDEOMASTER_HD_API const char* VHD_SDI_BUFFERTYPE_ToString(VHD_SDI_BUFFERTYPE value);
   VIDEOMASTER_HD_API const char* VHD_SDI_BUFFERTYPE_ToPrettyString(VHD_SDI_BUFFERTYPE value);

   VIDEOMASTER_HD_API const char* VHD_HDMISOURCE_ToString(VHD_HDMISOURCE value);
   VIDEOMASTER_HD_API const char* VHD_HDMISOURCE_ToPrettyString(VHD_HDMISOURCE value);

   VIDEOMASTER_HD_API const char* VHD_INTERFACE_ToString(VHD_INTERFACE value);
   VIDEOMASTER_HD_API const char* VHD_INTERFACE_ToPrettyString(VHD_INTERFACE value);

   VIDEOMASTER_HD_API const char* VHD_SDI_BOARD_CAPABILITY_ToString(VHD_SDI_BOARD_CAPABILITY value);
   VIDEOMASTER_HD_API const char* VHD_SDI_BOARD_CAPABILITY_ToPrettyString(VHD_SDI_BOARD_CAPABILITY value);

   VIDEOMASTER_HD_API const char* VHD_SDI_TRANSFER_CHARACTERISTICS_ToString(VHD_SDI_TRANSFER_CHARACTERISTICS value);
   VIDEOMASTER_HD_API const char* VHD_SDI_TRANSFER_CHARACTERISTICS_ToPrettyString(VHD_SDI_TRANSFER_CHARACTERISTICS value);

   VIDEOMASTER_HD_API const char* VHD_SDI_COLORIMETRY_ToString(VHD_SDI_COLORIMETRY value);
   VIDEOMASTER_HD_API const char* VHD_SDI_COLORIMETRY_ToPrettyString(VHD_SDI_COLORIMETRY value);

   VIDEOMASTER_HD_API const char* VHD_SDI_SIGNALPACKING_ToString(VHD_SDI_SIGNALPACKING value);
   VIDEOMASTER_HD_API const char* VHD_SDI_SIGNALPACKING_ToPrettyString(VHD_SDI_SIGNALPACKING value);

   VIDEOMASTER_HD_API const char* VHD_BLACKBURST_OUTPUT_SOURCE_ToString(VHD_BLACKBURST_OUTPUT_SOURCE value);
   VIDEOMASTER_HD_API const char* VHD_BLACKBURST_OUTPUT_SOURCE_ToPrettyString(VHD_BLACKBURST_OUTPUT_SOURCE value);

   VIDEOMASTER_HD_API const char* VHD_BLACKBURST_OUTPUT_STATUS_ToString(VHD_BLACKBURST_OUTPUT_STATUS value);
   VIDEOMASTER_HD_API const char* VHD_BLACKBURST_OUTPUT_STATUS_ToPrettyString(VHD_BLACKBURST_OUTPUT_STATUS value);

   VIDEOMASTER_HD_API const char* VHD_MULTICARD_SYNC_OUTPUT_SOURCE_ToString(VHD_MULTICARD_SYNC_OUTPUT_SOURCE value);
   VIDEOMASTER_HD_API const char* VHD_MULTICARD_SYNC_OUTPUT_SOURCE_ToPrettyString(VHD_MULTICARD_SYNC_OUTPUT_SOURCE value);

   VIDEOMASTER_HD_API const char* VHD_SDI_CHANNELPROPERTY_ToString(VHD_SDI_CHANNELPROPERTY value);
   VIDEOMASTER_HD_API const char* VHD_SDI_CHANNELPROPERTY_ToPrettyString(VHD_SDI_CHANNELPROPERTY value);

/* -------------------------------- */
/* VideomasterHD_Sdi_Hdr_Metadata.h */
/* -------------------------------- */

   VIDEOMASTER_HD_API const char* VHD_HDRMETADATA_TYPE_ToString(VHD_HDRMETADATA_TYPE value);
   VIDEOMASTER_HD_API const char* VHD_HDRMETADATA_TYPE_ToPrettyString(VHD_HDRMETADATA_TYPE value);

   VIDEOMASTER_HD_API const char* VHD_HDRMETADATA_ST2108_FRAME_TYPE_ToString(VHD_HDRMETADATA_ST2108_FRAME_TYPE value);
   VIDEOMASTER_HD_API const char* VHD_HDRMETADATA_ST2108_FRAME_TYPE_ToPrettyString(VHD_HDRMETADATA_ST2108_FRAME_TYPE value);

/* -------------------------------- */
/* VideomasterHD_Sdi_Keyer.h        */
/* -------------------------------- */

   VIDEOMASTER_HD_API const char* VHD_KEYER_BOARDPROPERTY_ToString(VHD_KEYER_BOARDPROPERTY value);
   VIDEOMASTER_HD_API const char* VHD_KEYER_BOARDPROPERTY_ToPrettyString(VHD_KEYER_BOARDPROPERTY value);

   VIDEOMASTER_HD_API const char* VHD_KEYERINPUT_ToString(VHD_KEYERINPUT value);
   VIDEOMASTER_HD_API const char* VHD_KEYERINPUT_ToPrettyString(VHD_KEYERINPUT value);

   VIDEOMASTER_HD_API const char* VHD_KEYEROUTPUT_ToString(VHD_KEYEROUTPUT value);
   VIDEOMASTER_HD_API const char* VHD_KEYEROUTPUT_ToPrettyString(VHD_KEYEROUTPUT value);

   VIDEOMASTER_HD_API const char* VHD_KEYERBLENDINGTYPE_ToString(VHD_KEYERBLENDINGTYPE value);
   VIDEOMASTER_HD_API const char* VHD_KEYERBLENDINGTYPE_ToPrettyString(VHD_KEYERBLENDINGTYPE value);

   VIDEOMASTER_HD_API const char* VHD_KEYERANCOVERRIDE_ToString(VHD_KEYERANCOVERRIDE value);
   VIDEOMASTER_HD_API const char* VHD_KEYERANCOVERRIDE_ToPrettyString(VHD_KEYERANCOVERRIDE value);

   VIDEOMASTER_HD_API const char* VHD_KEYER_BOARD_CAPABILITY_ToString(VHD_KEYER_BOARD_CAPABILITY value);
   VIDEOMASTER_HD_API const char* VHD_KEYER_BOARD_CAPABILITY_ToPrettyString(VHD_KEYER_BOARD_CAPABILITY value);

/* -------------------------------- */
/* VideomasterHD_Sdi_Timecode.h     */
/* -------------------------------- */

   VIDEOMASTER_HD_API const char* VHD_TIMECODETYPE_ToString(VHD_TIMECODETYPE value);
   VIDEOMASTER_HD_API const char* VHD_TIMECODETYPE_ToPrettyString(VHD_TIMECODETYPE value);

/* -------------------------------- */
/* VideomasterHD_SDP.h"             */
/* -------------------------------- */

   VIDEOMASTER_HD_API const char* VHD_SDP_DESCRIPTION_TYPE_ToString(VHD_SDP_DESCRIPTION_TYPE value);
   VIDEOMASTER_HD_API const char* VHD_SDP_DESCRIPTION_TYPE_ToPrettyString(VHD_SDP_DESCRIPTION_TYPE value);

   VIDEOMASTER_HD_API const char* VHD_SDP_SESSION_FIELD_ToString(VHD_SDP_SESSION_FIELD value);
   VIDEOMASTER_HD_API const char* VHD_SDP_SESSION_FIELD_ToPrettyString(VHD_SDP_SESSION_FIELD value);

   VIDEOMASTER_HD_API const char* VHD_SDP_TIME_FIELD_ToString(VHD_SDP_TIME_FIELD value);
   VIDEOMASTER_HD_API const char* VHD_SDP_TIME_FIELD_ToPrettyString(VHD_SDP_TIME_FIELD value);

   VIDEOMASTER_HD_API const char* VHD_SDP_MEDIA_FIELD_ToString(VHD_SDP_MEDIA_FIELD value);
   VIDEOMASTER_HD_API const char* VHD_SDP_MEDIA_FIELD_ToPrettyString(VHD_SDP_MEDIA_FIELD value);

   VIDEOMASTER_HD_API const char* VHD_SDP_ST2110_21_SENDER_TYPE_ToString(VHD_SDP_ST2110_21_SENDER_TYPE value);
   VIDEOMASTER_HD_API const char* VHD_SDP_ST2110_21_SENDER_TYPE_ToPrettyString(VHD_SDP_ST2110_21_SENDER_TYPE value);

   VIDEOMASTER_HD_API const char* VHD_SDP_STREAM_PROPERTY_ToString(VHD_SDP_STREAM_PROPERTY value);
   VIDEOMASTER_HD_API const char* VHD_SDP_STREAM_PROPERTY_ToPrettyString(VHD_SDP_STREAM_PROPERTY value);

/* -------------------------------- */
/* VideomasterHD_Dv.h"             */
/* -------------------------------- */

   VIDEOMASTER_HD_API const char* VHD_DV_CHANNELPROPERTY_ToString(VHD_DV_CHANNELPROPERTY value);
   VIDEOMASTER_HD_API const char* VHD_DV_CHANNELPROPERTY_ToPrettyString(VHD_DV_CHANNELPROPERTY value);


#ifdef __cplusplus
}
#endif

#endif /* EXCLUDE_API_FUNCTIONS */

#endif // _VIDEOMASTERHD_STRING_H_
