/*! VideomasterHD_Ip_ST2110_40_Board.h

    Copyright (c) 2009, DELTACAST. All rights reserved.

    THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
    KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
    IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR
    PURPOSE.

  Project : Videomaster

  Package : 

  Company : DELTACAST

  Author  : lr                             Date: 2019/04/02

  Purpose : 

*/


#ifndef _VIDEOMASTERHD_IP_ST2110_40_H_
#define _VIDEOMASTERHD_IP_ST2110_40_H_

/*_ CONSTANTS ________________________________________________________________
//
// This section defines the different constants used by VideomasterHD_Ip_ST2110_40
*/

/*_ ENUMERATIONS _____________________________________________________________
//
// This section defines the different enumerations used by VideomasterHD_Ip_ST2110_40
*/

/*_ STRUCTURES _______________________________________________________________
//
// This section defines the different structures used by VideomasterHD_Ip_ST2110_40
*/

#ifndef EXCLUDE_API_FUNCTIONS

#ifdef __cplusplus
extern "C" {
#endif

/*** VHD_GetSlotRTPAncTimeStamp ****************************************************/
/*!
   Summary
   Get slot RTP ANC timestamp
   Description
   This function gets the RTP ANC timestamp of a given slot handle.

   Parameters
   SlotHandle :         Handle of the slot to work with
   pSlotTimestamp :     Pointer to a caller\-allocated variable 
                           where the timestamp is returned

   Returns
   The function returns the status of its execution as
   VideoMaster error code (see VHD_ERRORCODE enumeration)
*/
ULONG VIDEOMASTER_HD_API VHD_GetSlotRTPAncTimeStamp(HANDLE SlotHandle, ULONG *pSlotTimestamp);

#ifdef __cplusplus
}
#endif

#endif //EXCLUDE_API_FUNCTIONS

#endif //_VIDEOMASTERHD_IP_ST2110_40_H_