#!/bin/sh
###############################################################################
#                     DPDK installation shell script                        #
###############################################################################

install_dpdk()
{
   mlnx_param="mlnx5"
   basics_drivers=common/iavf,net/i40e,net/ixgbe,net/e1000,net/igb,net/ice,net/cxgbe,net/bnxt,net/kni,mempool/ring
   mlnx_drivers=bus/auxiliary,common/mlx5,net/mlx5
   enabled_drivers=""
   git clone http://dpdk.org/git/dpdk-stable
   cd dpdk-stable
   git checkout v22.11.1
   #apply patches futher use
   cd ../
   patch -p0 < kniPTP.patch
   patch -p0 < version.patch
   cd dpdk-stable
   #install only necessary libs and drivers from dpdk
    if [ "$1" = "$mlnx_param" ]
    then
       enabled_drivers=${basics_drivers},${mlnx_drivers}
   else
       enabled_drivers=${basics_drivers}
   fi

   meson -Denable_kmods=true -Dtests=false -Ddisable_libs="" -Denable_drivers=$enabled_drivers build
   cd build
   ninja
   sudo ninja install
   cd ../../
   git clone http://dpdk.org/git/dpdk-kmods
   cd dpdk-kmods/linux/igb_uio/
   make
   modprobe uio
   sudo test -n "$(grep -e "^igb_uio" /proc/modules)" && sudo rmmod igb_uio
   insmod igb_uio.ko
}


check_access_right()
{
   if [ $(id -u) -ne 0 ]; then 
      echo "Please run as root"
      exit 1 
   fi
}

case "$1" in 
    
    *) 
      check_access_right
      install_dpdk $1
        ;; 
esac   
