#!/usr/bin/env python3

'''
This script is intended to create all relevant phc2sys services to synchronize multiple NICs
'''

import sys
import os
import glob

template_service_file="""
[Unit]
Description=Synchronize PTP hardware clock (PHC)
Documentation=man:phc2sys
After=ntpdate.service
Requires=phc2sys.service
After=phc2sys.service

[Service]
Type=simple
ExecStart=/usr/local/sbin/phc2sys -s {main_interface} -c {follower_interface} -w -n {ptp_domain} -q

[Install]
WantedBy=multi-user.target
"""

def print_usage():
    print('USAGE:\n' +
          'config_nic_sync.py [ptp_domain] [main_interface] [follower_interface] ... [follower_interface] --- Create and load all the required services\n' + 
          'config_nic_sync.py clean    --- Clean previous configuration\n' +
          'config_nic_sync.py start    --- Start all sync services\n' +
          'config_nic_sync.py restart  --- Restart all sync services\n' + 
          'config_nic_sync.py stop     --- Stop all sync services\n'
          )

def remove_services():
    file_list = glob.glob('/lib/systemd/system/DELTACAST-phcsync*')
    for file_path in file_list:
        try:
            os.remove(file_path)
        except:
            print("Error while deleting file : ", file_path)

def services_action(action):
    file_list = glob.glob('/lib/systemd/system/DELTACAST-phcsync*')
    for file_path in file_list:
        service_name = os.path.basename(file_path);
        try:
            os.system('systemctl ' + str(action) + ' ' + service_name)
            print('systemctl '+ str(action) + ' ' + service_name)
        except:
            print("Error running command service : ", file_path)

def main():
    nb_arguments = len(sys.argv)

    if nb_arguments == 2:
        if str(sys.argv[1]) == 'clean':
            services_action('stop')
            services_action('disable')
            remove_services()
            os.system('systemctl daemon-reload')

        elif str(sys.argv[1]) == 'start' or str(sys.argv[1]) == 'stop' or str(sys.argv[1]) == 'restart':
            services_action(sys.argv[1])
        else :
            print_usage()

    elif nb_arguments > 3:

        #Deleting previous phcsync services
        services_action('stop')
        services_action('disable')
        remove_services()

        #Creating phcsync services files
        for i in range(3,nb_arguments):
            service_file = open('/lib/systemd/system/DELTACAST-phcsync-'+str(sys.argv[i])+'.service', 'w')
            service_file.write(template_service_file.format(ptp_domain = str(sys.argv[1]), main_interface = str(sys.argv[2]), follower_interface = str(sys.argv[i])));
            service_file.close()
        services_action('enable')
        os.system('systemctl daemon-reload')
        services_action('start')
        
    else:
        print_usage()

if __name__=='__main__':
    #Must be run with admin rights
    if os.getuid() != 0:
      print('Operation not permitted, please run this script as root user')
    else:
        main()