import sys


## Following lines are for compatibility between python 2.x and 3.x
try:
   input = raw_input
except NameError:
   pass

# Display results in color
class bcolors:
    RED   =      '\033[31m'
    GREEN =      '\033[32m'
    YELLOW=      '\033[33m'
    BLUE  =      '\033[34m'
    RED_BGND =   '\033[37;41m'
    GREEN_BGND = '\033[37;42m'
    ENDC  =      '\033[0m'

def green_str(s):
   return bcolors.GREEN+s+bcolors.ENDC

def red_str(s):
   return bcolors.RED+s+bcolors.ENDC

def yellow_str(s):
   return bcolors.YELLOW+s+bcolors.ENDC

def blue_str(s):
   return bcolors.BLUE+s+bcolors.ENDC

# parse a comma-separated range list and return the list of ids
def parse_int_range(int_range):
   ids = []
   clean_input = ''
   for x in int_range.split(','):
      x.strip()
      if len(x) == 0: continue
      if x.isdigit():
         ids.append(int(x))
      elif x[0] == '<':
         ids.extend(range(0,int(x[1:])+1))
      elif '-' in x:
         xr = x.split('-')
         ids.extend(range(int(xr[0].strip()), int(xr[1].strip())+1))
      else:
         continue
      clean_input += x+','
   clean_input = clean_input[:-1]
   return ids, clean_input

# query_yes_no taken from http://code.activestate.com/recipes/577058/
def query_yes_no(question, default="yes"):
   """Ask a yes/no question via raw_input() and return their answer.

   "question" is a string that is presented to the user.
   "default" is the presumed answer if the user just hits <Enter>.
       It must be "yes" (the default), "no" or None (meaning
       an answer is required of the user).

   The "answer" return value is True for "yes" or False for "no".
   """
   valid = {"yes": True, "y": True, "ye": True,
            "no": False, "n": False}
   if default is None:
      prompt = " [y/n] "
   elif default == "yes":
      prompt = " [Y/n] "
   elif default == "no":
      prompt = " [y/N] "
   else:
      raise ValueError("invalid default answer: '%s'" % default)

   while True:
      print(question + prompt)
      choice = input().lower()
      if default is not None and choice == '':
         return valid[default]
      elif choice in valid:
         return valid[choice]
      else:
         sys.stdout.write("Please respond with 'yes' or 'no' "
                          "(or 'y' or 'n').\n")

def query_number(question, default):
   prompt = ' [{}] '.format(default)
   while True:
      choice = input(question + prompt)
      if choice == '':
         return default
      elif choice.isdigit():
         return int(choice)
      else:
         print('Please enter a valid number\n')

