#!/bin/sh
###############################################################################
#                     KBDPDK installation shell script                        #
###############################################################################

set_member_variables()
{
	VAR_KBDPDK_DIR=`pwd`
	KBDPDK_TAR_NAME=$(find . -type f -name "kbdpdk*.tar.gz")
	KBDPDK_FOLDER=$(basename "${KBDPDK_TAR_NAME}" .tar.gz)
}

install_kbdpdk()
{
	DIR=$(mktemp -d)
	cd $DIR
	tar xaf $VAR_KBDPDK_DIR/$KBDPDK_TAR_NAME
	cd $DIR/$KBDPDK_FOLDER/lib/DPDK
	#install dpdk DPDK
	sh install_dpdk.sh $1
	cd $DIR/$KBDPDK_FOLDER/lib/
	make
	make install_all
	rm -rf $DIR
}


check_access_right()
{
	if [ $(id -u) -ne 0 ]; then 
		echo "Please run as root"
		exit 1 
	fi
}

case "$1" in 
    
    *) 
		check_access_right
		set_member_variables
		install_kbdpdk $1
        ;; 
esac    