#!/usr/bin/env python

import sys
import os
import subprocess
import platform
import re
import argparse
import tempfile

from kbutils import *

__script_desc__='This script restores the system to its original configuration.'
__version_info__ = (1, 0, 0)
__version__ = '.'.join(map(str,__version_info__))

def restore_config():
   # retore grub configuration
   backup_name = '/etc/default/.grub_kbdpdk_saved'
   if os.path.isfile(backup_name):
      if subprocess.call(['mv', backup_name, '/etc/default/grub']):
          print(red_str('Failed to restore the grub configuration file'))
          return 1

   # remove the kbconfig.conf file
   config_name = '/etc/kbdpdk/kbconfig.conf'
   if os.path.isfile(config_name):
      os.remove(config_name)

   return 0

def main(args=None):
   parser = argparse.ArgumentParser(description=__script_desc__)
   parser.add_argument('-v', '--version', help='show program version', 
                       action='version', 
                       version='{} version {}\n'.format(os.path.basename(__file__), __version__))
   args = parser.parse_args(args)

   if os.getuid() != 0:
      print('Operation not permitted, please run this script as root user')
      return 1

   question = 'Do you want to restore the original configuration?'
   if query_yes_no(question):
      ret = restore_config()

   if ret == 0:
      print('Done. You need to reboot the system to apply the original configuration.')
   else:
      print(red_str('Error while restoring configuration'))

   return ret

if __name__ == '__main__':
   sys.exit(main())

