#!/bin/sh
###############################################################################
#                     KBDPDK installation shell script                        #
###############################################################################

set_member_variables()
{
	VAR_KBDPDK_DIR=`pwd`
	KBDPDK_TAR_NAME=$(find . -type f -name "kbdpdk*.tar.gz")
	KBDPDK_FOLDER=$(basename "${KBDPDK_TAR_NAME}" .tar.gz)
}

install_kbdpdk()
{
	tar xaf $KBDPDK_TAR_NAME
	cd $VAR_KBDPDK_DIR/$KBDPDK_FOLDER/lib/DPDK
 
	DPDK_TAR_NAME=$(find . -type f -name "dpdk*.tar.xz")
	#uncompress DPDK
	tar xaf $DPDK_TAR_NAME
 
	#Applying patches
	for file in *.patch
	do
		patch -p0 < $file
	done
  
	DPDK_FOLDER=$(find . -type d -name "dpdk*")
	DPDK_FOLDER_NAME=$(basename "${DPDK_FOLDER}")

	cd $DPDK_FOLDER_NAME
	export RTE_TARGET=x86_64-native-linux-gcc
	make config T=$RTE_TARGET
	EXTRA_CFLAGS="-fPIC" make all
	cd ../../..
	cd lib
	make
	make install_all
}


check_access_right()
{
	if [ $(id -u) -ne 0 ]; then 
		echo "Please run as root"
		exit 1 
	fi
}

case "$1" in 
    
    *) 
		check_access_right
		set_member_variables
		install_kbdpdk
        ;; 
esac    	   
