# IP Virtual Card Linux installation guide

- [Delivery](#delivery)
  - [Installation](#installation)
  - [KBDPDK](#kbdpdk)
    - [Installation](#kbapi-installation)
    - [Configuration](#kbapi-configuration)
    - [Clean](#kbapi-clean)
- [Target platform](#target-platform)
- [Performance considerations](#performance-considerations)
  - [Socket](#socket)
  - [BIOS](#bios)
  - [CPU governor](#cpu-governor)
  - [Conductor configuration](#conductor-configuration)
  - [Route](#route)
- [Licensing](#licensing)

## Delivery

The package contains all the resources needed to run the IP virtual card.

Once this package is installed, you will be able to run any application linked to the IP Virtual Card solution.

### Installation

The installation is automated by the script `install.sh`.

This script must be launched with root privilege :

    sudo sh install.sh

The script will :

- install some needed packages
- disable NTP
- install and register `ptp4l` as a service
- install the VideoMasterIP libraries
- install and register the VirtualCardService as a service
- install licensing module

The script can also be launched with the following argument :

- `clean` :  this will remove everything that has been done during installation
- `update` : this will update the existing libraries and VirtualCardService executable without reinstalling all the needed packages like 'ptp4l' etc.

### KBDPDK

Redist and dev packages contain KBDPDK package in their library/external folder.
To activate DPDK, the KBDPDK package must be installed separately.

The first thing to do before installing KBDPDK is to check the compatibility with your system.
The following script is located in `library/external/kbdpdk`

     sudo ./kbcheck_compat

This script requires python (v2.7 or v3.6 and higher) to be installed on the system.

#### KBAPI Installation

The installation is automated by the script `install.sh` located in `library/external/kbdpdk`.

This script must be launched with root privilege :

     sudo sh install.sh

The script will :

- Compile DPDK
- Install the kbdpdk utility scripts
- Install the kbapi library.

#### KBAPI Configuration

The kbapi is configured via a python script. This script is installed on the system and can be executed from anywhere on the system.

     sudo kbconfig_setup.py

This script is an interactive script that helps you to configure the kbapi:

- Configure the NIC used by the kbapi
- Configure the hugepages
- Configure the cpu core isolation

A reboot is necessary after executing this script and applying the configuration.

After reboot run the script that allows you to check that the kbapi is properly configured:

    sudo kbcheck_config.py

#### KBAPI Clean

This script cleans the kbapi configuration on your system:

    sudo kbconfig_cleanup.py

#### VCS configuration

Packag installation copies two vcs config files:

- vcsconfig.xml that contains recommended parameters for socket mode
- vcsconfig_dpdk.xml that contains recommended parameters for DPDK mode

Note that vcs reads its configuration from vcsconfig.xml file. So you need to modify vcsconfig.xml according to the vcsconfig_dpdk.xml content.

## Target platform

Hardware :

- CPU speed : minimum 2.1GHz
- CPU architecture : 64 bits
- NIC bandwidth : minimum 10Gb/s

OS :

- Ubuntu 18.04 64 bits
- NIC driver must be properly installed and up to date

## Performance considerations

### Socket

Redist package installs a script that is launched at each startup and that improves the socket performance.  
You can find that script here : `/opt/deltacast/videomasterip/vcs/network_sysctl.sh`

Explanations :  
`sysctl -w net.core.rmem_max=33554432`  
This sets the max OS receive buffer size for all types of connections.

`sysctl -w net.core.wmem_max=33554432`  
This sets the max OS send buffer size for all types of connections.

`sysctl -w net.core.rmem_default=65536`  
This sets the default OS receive buffer size for all types of connections.

`sysctl -w net.core.wmem_default=65536`  
This sets the default OS send buffer size for all types of connections.

`sysctl -w net.ipv4.route.flush=1`  
This will ensure that immediately subsequent connections use these values.

### BIOS

According to our observations, C-states, P-states or any energy-saving parameters must be disabled in the BIOS parameter.

This ensures that the computer is running at its peak performances.

Not following the recommendations can lead to unstable or non-compliant streams.

### CPU governor

We strongly recommand to disable `ondemand` CPU scaling daemon to ensure best performances:  
`sudo systemctl disable ondemand`

To avoid reboot, you can manually change the actual scaling gorvernor:  
`echo performance | sudo tee /sys/devices/system/cpu/cpu*/cpufreq/scaling_governor`

### Conductor configuration

The CPU core associated to a conductor must not be used by any process.  
To avoid kernel interruption on this core, it can be isolated at boot via the option `isolcpus` or with the KBAPI configuration (in case of DPDK mode).

If the hyper-threading is activated, the same guideline must be applied to the associated logical core.

### Route

In order to improve the performances during a TX stream emitting toward a multicast address, it is advised to set a general multicast route associated with the used NIC.  

This can be done thanks to the following command :  
`sudo route add -net 224.0.0.0/4 dev xxxx`,  
where 'xxxx' is the name of the NIC.

Without this route, the packet interval time (PIT) will not be stable and this can cause non-compliance to the ST2110-21 packet pacing standard (overflow in the VRX bucket).

## Licensing

The IP Virtual Card solution is secured by a license manager called **dlmcli**.

To identify the platform, dlmcli take several parameters into account. One of those parameters is one of the NIC MAC.
To avoid license issue in case of network configuration changes, we recommend to force dlmcli to use a specific NIC MAC that should never be removed or used by IP Virtual Card (mainboard NIC by example). For that, use the following argument while you add the first license:  
`--select-custom-mac ############`

If a custom mac is not provided with the first license entry, dlmcli will warn you and list all the available NIC mac.

**To add a license**, use the following command:  
`dlmcli activate --offline requestfile.bin ####-####-####-####-####-####-####-#### [--select-custom-mac ############]`  
Provide the processed requestfile.bin to Deltacast. In return, Deltacast will provide you a response file. Then use the following command:  
`dlmcli process responsefile.bin`
