#!/usr/bin/env python
import sys
import os
import argparse
import kbtools

__script_desc__='This script displays the list of detected NICs.'
__version_info__ = (1, 0, 0)
__version__ = '.'.join(map(str,__version_info__))

def main(args=None):
   parser = argparse.ArgumentParser(description=__script_desc__)
   parser.add_argument('-v', '--version', help='show program version', 
                       action='version',
                       version='{} version {}\n'.format(os.path.basename(__file__), __version__))
   args = parser.parse_args(args)

   nic_list = kbtools.get_nic_list()

   print('Detected network devices')
   print('========================')
   print('')
   kbtools.disp_nic_list(nic_list)
   print('')

if __name__ == '__main__':
   sys.exit(main())

